<?php
// This file was auto-generated from sdk-root/src/data/rtbfabric/2023-05-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-05-15', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'rtbfabric', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'RTBFabric', 'serviceFullName' => 'RTBFabric', 'serviceId' => 'RTBFabric', 'signatureVersion' => 'v4', 'signingName' => 'rtbfabric', 'uid' => 'rtbfabric-2023-05-15', ], 'operations' => [ 'AcceptLink' => [ 'name' => 'AcceptLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}/accept', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AcceptLinkRequest', ], 'output' => [ 'shape' => 'AcceptLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateInboundExternalLink' => [ 'name' => 'CreateInboundExternalLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/responder-gateway/{gatewayId}/inbound-external-link', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateInboundExternalLinkRequest', ], 'output' => [ 'shape' => 'CreateInboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateLink' => [ 'name' => 'CreateLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateway/{gatewayId}/create-link', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateLinkRequest', ], 'output' => [ 'shape' => 'CreateLinkResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateOutboundExternalLink' => [ 'name' => 'CreateOutboundExternalLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/requester-gateway/{gatewayId}/outbound-external-link', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateOutboundExternalLinkRequest', ], 'output' => [ 'shape' => 'CreateOutboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateRequesterGateway' => [ 'name' => 'CreateRequesterGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/requester-gateway', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateRequesterGatewayRequest', ], 'output' => [ 'shape' => 'CreateRequesterGatewayResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateResponderGateway' => [ 'name' => 'CreateResponderGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/responder-gateway', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateResponderGatewayRequest', ], 'output' => [ 'shape' => 'CreateResponderGatewayResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteInboundExternalLink' => [ 'name' => 'DeleteInboundExternalLink', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/responder-gateway/{gatewayId}/inbound-external-link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteInboundExternalLinkRequest', ], 'output' => [ 'shape' => 'DeleteInboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteLink' => [ 'name' => 'DeleteLink', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteLinkRequest', ], 'output' => [ 'shape' => 'DeleteLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteOutboundExternalLink' => [ 'name' => 'DeleteOutboundExternalLink', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/requester-gateway/{gatewayId}/outbound-external-link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteOutboundExternalLinkRequest', ], 'output' => [ 'shape' => 'DeleteOutboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteRequesterGateway' => [ 'name' => 'DeleteRequesterGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/requester-gateway/{gatewayId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteRequesterGatewayRequest', ], 'output' => [ 'shape' => 'DeleteRequesterGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteResponderGateway' => [ 'name' => 'DeleteResponderGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/responder-gateway/{gatewayId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteResponderGatewayRequest', ], 'output' => [ 'shape' => 'DeleteResponderGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'GetInboundExternalLink' => [ 'name' => 'GetInboundExternalLink', 'http' => [ 'method' => 'GET', 'requestUri' => '/responder-gateway/{gatewayId}/inbound-external-link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetInboundExternalLinkRequest', ], 'output' => [ 'shape' => 'GetInboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'GetLink' => [ 'name' => 'GetLink', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLinkRequest', ], 'output' => [ 'shape' => 'GetLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'GetOutboundExternalLink' => [ 'name' => 'GetOutboundExternalLink', 'http' => [ 'method' => 'GET', 'requestUri' => '/requester-gateway/{gatewayId}/outbound-external-link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOutboundExternalLinkRequest', ], 'output' => [ 'shape' => 'GetOutboundExternalLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'GetRequesterGateway' => [ 'name' => 'GetRequesterGateway', 'http' => [ 'method' => 'GET', 'requestUri' => '/requester-gateway/{gatewayId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRequesterGatewayRequest', ], 'output' => [ 'shape' => 'GetRequesterGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'GetResponderGateway' => [ 'name' => 'GetResponderGateway', 'http' => [ 'method' => 'GET', 'requestUri' => '/responder-gateway/{gatewayId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetResponderGatewayRequest', ], 'output' => [ 'shape' => 'GetResponderGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListLinks' => [ 'name' => 'ListLinks', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateway/{gatewayId}/links/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLinksRequest', ], 'output' => [ 'shape' => 'ListLinksResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListRequesterGateways' => [ 'name' => 'ListRequesterGateways', 'http' => [ 'method' => 'GET', 'requestUri' => '/requester-gateways', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRequesterGatewaysRequest', ], 'output' => [ 'shape' => 'ListRequesterGatewaysResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListResponderGateways' => [ 'name' => 'ListResponderGateways', 'http' => [ 'method' => 'GET', 'requestUri' => '/responder-gateways', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListResponderGatewaysRequest', ], 'output' => [ 'shape' => 'ListResponderGatewaysResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'readonly' => true, ], 'RejectLink' => [ 'name' => 'RejectLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}/reject', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RejectLinkRequest', ], 'output' => [ 'shape' => 'RejectLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateLink' => [ 'name' => 'UpdateLink', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLinkRequest', ], 'output' => [ 'shape' => 'UpdateLinkResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateLinkModuleFlow' => [ 'name' => 'UpdateLinkModuleFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateway/{gatewayId}/link/{linkId}/module-flow', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLinkModuleFlowRequest', ], 'output' => [ 'shape' => 'UpdateLinkModuleFlowResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateRequesterGateway' => [ 'name' => 'UpdateRequesterGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/requester-gateway/{gatewayId}/update', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateRequesterGatewayRequest', ], 'output' => [ 'shape' => 'UpdateRequesterGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateResponderGateway' => [ 'name' => 'UpdateResponderGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/responder-gateway/{gatewayId}/update', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateResponderGatewayRequest', ], 'output' => [ 'shape' => 'UpdateResponderGatewayResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AcceptLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'logSettings', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'logSettings' => [ 'shape' => 'LinkLogSettings', ], ], ], 'AcceptLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'status', 'createdAt', 'updatedAt', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'direction' => [ 'shape' => 'LinkDirection', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'linkId' => [ 'shape' => 'LinkId', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'Action' => [ 'type' => 'structure', 'members' => [ 'noBid' => [ 'shape' => 'NoBidAction', ], 'headerTag' => [ 'shape' => 'HeaderTagAction', ], ], 'union' => true, ], 'AutoScalingGroupName' => [ 'type' => 'string', ], 'AutoScalingGroupNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutoScalingGroupName', ], ], 'AutoScalingGroupsConfiguration' => [ 'type' => 'structure', 'required' => [ 'autoScalingGroupNames', 'roleArn', ], 'members' => [ 'autoScalingGroupNames' => [ 'shape' => 'AutoScalingGroupNameList', ], 'roleArn' => [ 'shape' => 'String', ], ], ], 'Base64EncodedCertificateChain' => [ 'type' => 'string', 'max' => 2097152, 'min' => 1, 'sensitive' => true, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'CertificateAuthorityCertificates' => [ 'type' => 'list', 'member' => [ 'shape' => 'Base64EncodedCertificateChain', ], 'max' => 2, 'min' => 0, ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateInboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'clientToken', 'gatewayId', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateInboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'status', 'domainName', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'domainName' => [ 'shape' => 'DomainName', ], ], ], 'CreateLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'logSettings', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'httpResponderAllowed' => [ 'shape' => 'Boolean', ], 'tags' => [ 'shape' => 'TagsMap', ], 'logSettings' => [ 'shape' => 'LinkLogSettings', ], ], ], 'CreateLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'status', 'createdAt', 'updatedAt', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'direction' => [ 'shape' => 'LinkDirection', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'linkId' => [ 'shape' => 'LinkId', ], 'customerProvidedId' => [ 'shape' => 'CreateLinkResponseCustomerProvidedIdString', ], ], ], 'CreateLinkResponseCustomerProvidedIdString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{5,50}', ], 'CreateOutboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'clientToken', 'gatewayId', 'publicEndpoint', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'publicEndpoint' => [ 'shape' => 'URL', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateOutboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'CreateRequesterGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'vpcId', 'subnetIds', 'securityGroupIds', 'clientToken', ], 'members' => [ 'vpcId' => [ 'shape' => 'VpcId', ], 'subnetIds' => [ 'shape' => 'CreateRequesterGatewayRequestSubnetIdsList', ], 'securityGroupIds' => [ 'shape' => 'CreateRequesterGatewayRequestSecurityGroupIdsList', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'CreateRequesterGatewayRequestDescriptionString', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateRequesterGatewayRequestDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'CreateRequesterGatewayRequestSecurityGroupIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'min' => 1, ], 'CreateRequesterGatewayRequestSubnetIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'min' => 1, ], 'CreateRequesterGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'domainName', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'domainName' => [ 'shape' => 'DomainName', ], 'status' => [ 'shape' => 'RequesterGatewayStatus', ], ], ], 'CreateResponderGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'vpcId', 'subnetIds', 'securityGroupIds', 'port', 'protocol', 'clientToken', ], 'members' => [ 'vpcId' => [ 'shape' => 'VpcId', ], 'subnetIds' => [ 'shape' => 'CreateResponderGatewayRequestSubnetIdsList', ], 'securityGroupIds' => [ 'shape' => 'CreateResponderGatewayRequestSecurityGroupIdsList', ], 'domainName' => [ 'shape' => 'DomainName', ], 'port' => [ 'shape' => 'CreateResponderGatewayRequestPortInteger', ], 'protocol' => [ 'shape' => 'Protocol', ], 'trustStoreConfiguration' => [ 'shape' => 'TrustStoreConfiguration', ], 'managedEndpointConfiguration' => [ 'shape' => 'ManagedEndpointConfiguration', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'CreateResponderGatewayRequestDescriptionString', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateResponderGatewayRequestDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'CreateResponderGatewayRequestPortInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 65535, 'min' => 1, ], 'CreateResponderGatewayRequestSecurityGroupIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'min' => 1, ], 'CreateResponderGatewayRequestSubnetIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'min' => 1, ], 'CreateResponderGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'ResponderGatewayStatus', ], ], ], 'CustomerProvidedId' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '[a-zA-Z0-9_-]+', ], 'DeleteInboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'DeleteInboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'linkId', 'status', ], 'members' => [ 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'DeleteLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'DeleteLinkResponse' => [ 'type' => 'structure', 'required' => [ 'linkId', 'status', ], 'members' => [ 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'DeleteOutboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'DeleteOutboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'linkId', 'status', ], 'members' => [ 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'DeleteRequesterGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], ], ], 'DeleteRequesterGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'RequesterGatewayStatus', ], ], ], 'DeleteResponderGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], ], ], 'DeleteResponderGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'ResponderGatewayStatus', ], ], ], 'DomainName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '(?:[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?)(?:\\.(?:[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?))+', ], 'EksEndpointsConfiguration' => [ 'type' => 'structure', 'required' => [ 'endpointsResourceName', 'endpointsResourceNamespace', 'clusterApiServerEndpointUri', 'clusterApiServerCaCertificateChain', 'clusterName', 'roleArn', ], 'members' => [ 'endpointsResourceName' => [ 'shape' => 'KubernetesEndpointsResourceName', ], 'endpointsResourceNamespace' => [ 'shape' => 'KubernetesNamespace', ], 'clusterApiServerEndpointUri' => [ 'shape' => 'URI', ], 'clusterApiServerCaCertificateChain' => [ 'shape' => 'Base64EncodedCertificateChain', ], 'clusterName' => [ 'shape' => 'KubernetesClusterName', ], 'roleArn' => [ 'shape' => 'String', ], ], ], 'Filter' => [ 'type' => 'structure', 'required' => [ 'criteria', ], 'members' => [ 'criteria' => [ 'shape' => 'FilterCriteria', ], ], ], 'FilterConfiguration' => [ 'type' => 'list', 'member' => [ 'shape' => 'Filter', ], ], 'FilterCriteria' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterCriterion', ], ], 'FilterCriterion' => [ 'type' => 'structure', 'required' => [ 'path', 'values', ], 'members' => [ 'path' => [ 'shape' => 'String', ], 'values' => [ 'shape' => 'FilterCriterionValuesList', ], ], ], 'FilterCriterionValuesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'min' => 1, ], 'FilterType' => [ 'type' => 'string', 'enum' => [ 'INCLUDE', 'EXCLUDE', ], ], 'FlowModuleName' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '[A-Za-z0-9 -]+', ], 'FlowModuleNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowModuleName', ], ], 'GatewayId' => [ 'type' => 'string', 'pattern' => 'rtb-gw-[a-z0-9-]{1,25}', ], 'GatewayIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GatewayId', ], ], 'GetInboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'GetInboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'status', 'domainName', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'domainName' => [ 'shape' => 'DomainName', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'GetLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'status', 'createdAt', 'updatedAt', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'direction' => [ 'shape' => 'LinkDirection', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'linkId' => [ 'shape' => 'LinkId', ], 'tags' => [ 'shape' => 'TagsMap', ], 'logSettings' => [ 'shape' => 'LinkLogSettings', ], ], ], 'GetOutboundExternalLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'GetOutboundExternalLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'status', 'publicEndpoint', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'publicEndpoint' => [ 'shape' => 'URL', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetRequesterGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], ], ], 'GetRequesterGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'status', 'domainName', 'vpcId', 'subnetIds', 'securityGroupIds', 'gatewayId', ], 'members' => [ 'status' => [ 'shape' => 'RequesterGatewayStatus', ], 'domainName' => [ 'shape' => 'DomainName', ], 'description' => [ 'shape' => 'GetRequesterGatewayResponseDescriptionString', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'vpcId' => [ 'shape' => 'VpcId', ], 'subnetIds' => [ 'shape' => 'GetRequesterGatewayResponseSubnetIdsList', ], 'securityGroupIds' => [ 'shape' => 'GetRequesterGatewayResponseSecurityGroupIdsList', ], 'gatewayId' => [ 'shape' => 'GatewayId', ], 'tags' => [ 'shape' => 'TagsMap', ], 'activeLinksCount' => [ 'shape' => 'Integer', ], 'totalLinksCount' => [ 'shape' => 'Integer', ], ], ], 'GetRequesterGatewayResponseDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'GetRequesterGatewayResponseSecurityGroupIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'min' => 1, ], 'GetRequesterGatewayResponseSubnetIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'min' => 1, ], 'GetResponderGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], ], ], 'GetResponderGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'vpcId', 'subnetIds', 'securityGroupIds', 'status', 'port', 'protocol', 'gatewayId', ], 'members' => [ 'vpcId' => [ 'shape' => 'VpcId', ], 'subnetIds' => [ 'shape' => 'GetResponderGatewayResponseSubnetIdsList', ], 'securityGroupIds' => [ 'shape' => 'GetResponderGatewayResponseSecurityGroupIdsList', ], 'status' => [ 'shape' => 'ResponderGatewayStatus', ], 'description' => [ 'shape' => 'GetResponderGatewayResponseDescriptionString', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'domainName' => [ 'shape' => 'DomainName', ], 'port' => [ 'shape' => 'GetResponderGatewayResponsePortInteger', ], 'protocol' => [ 'shape' => 'Protocol', ], 'trustStoreConfiguration' => [ 'shape' => 'TrustStoreConfiguration', ], 'managedEndpointConfiguration' => [ 'shape' => 'ManagedEndpointConfiguration', ], 'gatewayId' => [ 'shape' => 'GatewayId', ], 'tags' => [ 'shape' => 'TagsMap', ], 'activeLinksCount' => [ 'shape' => 'Integer', ], 'totalLinksCount' => [ 'shape' => 'Integer', ], 'inboundLinksCount' => [ 'shape' => 'Integer', ], ], ], 'GetResponderGatewayResponseDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'GetResponderGatewayResponsePortInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 65535, 'min' => 1, ], 'GetResponderGatewayResponseSecurityGroupIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'min' => 1, ], 'GetResponderGatewayResponseSubnetIdsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'min' => 1, ], 'HeaderTagAction' => [ 'type' => 'structure', 'required' => [ 'name', 'value', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'KubernetesClusterName' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9]', ], 'KubernetesEndpointsResourceName' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9]', ], 'KubernetesNamespace' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9]', ], 'LinkApplicationLogConfiguration' => [ 'type' => 'structure', 'required' => [ 'sampling', ], 'members' => [ 'sampling' => [ 'shape' => 'LinkApplicationLogSampling', ], ], ], 'LinkApplicationLogSampling' => [ 'type' => 'structure', 'required' => [ 'errorLog', 'filterLog', ], 'members' => [ 'errorLog' => [ 'shape' => 'LinkApplicationLogSamplingErrorLogDouble', ], 'filterLog' => [ 'shape' => 'LinkApplicationLogSamplingFilterLogDouble', ], ], ], 'LinkApplicationLogSamplingErrorLogDouble' => [ 'type' => 'double', 'box' => true, 'max' => 100.0, 'min' => 0.0, ], 'LinkApplicationLogSamplingFilterLogDouble' => [ 'type' => 'double', 'box' => true, 'max' => 100.0, 'min' => 0.0, ], 'LinkAttributes' => [ 'type' => 'structure', 'members' => [ 'responderErrorMasking' => [ 'shape' => 'ResponderErrorMasking', ], 'customerProvidedId' => [ 'shape' => 'CustomerProvidedId', ], ], ], 'LinkDirection' => [ 'type' => 'string', 'enum' => [ 'RESPONSE', 'REQUEST', ], ], 'LinkId' => [ 'type' => 'string', 'pattern' => 'link-[a-z0-9-]{1,25}', ], 'LinkList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListLinksResponseStructure', ], ], 'LinkLogSettings' => [ 'type' => 'structure', 'required' => [ 'applicationLogs', ], 'members' => [ 'applicationLogs' => [ 'shape' => 'LinkApplicationLogConfiguration', ], ], ], 'LinkStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING_CREATION', 'PENDING_REQUEST', 'REQUESTED', 'ACCEPTED', 'ACTIVE', 'REJECTED', 'FAILED', 'PENDING_DELETION', 'DELETED', 'PENDING_UPDATE', 'PENDING_ISOLATION', 'ISOLATED', 'PENDING_RESTORATION', ], ], 'ListLinksRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListLinksResponse' => [ 'type' => 'structure', 'members' => [ 'links' => [ 'shape' => 'LinkList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListLinksResponseStructure' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'status', 'createdAt', 'updatedAt', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'direction' => [ 'shape' => 'LinkDirection', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'linkId' => [ 'shape' => 'LinkId', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ListRequesterGatewaysRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListRequesterGatewaysRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListRequesterGatewaysRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'ListRequesterGatewaysResponse' => [ 'type' => 'structure', 'members' => [ 'gatewayIds' => [ 'shape' => 'GatewayIdList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListResponderGatewaysRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListResponderGatewaysRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListResponderGatewaysRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'ListResponderGatewaysResponse' => [ 'type' => 'structure', 'members' => [ 'gatewayIds' => [ 'shape' => 'GatewayIdList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'RtbTaggableResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ManagedEndpointConfiguration' => [ 'type' => 'structure', 'members' => [ 'autoScalingGroups' => [ 'shape' => 'AutoScalingGroupsConfiguration', ], 'eksEndpoints' => [ 'shape' => 'EksEndpointsConfiguration', ], ], 'union' => true, ], 'ModuleConfiguration' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'version' => [ 'shape' => 'Version', ], 'name' => [ 'shape' => 'FlowModuleName', ], 'dependsOn' => [ 'shape' => 'FlowModuleNameList', ], 'moduleParameters' => [ 'shape' => 'ModuleParameters', ], ], ], 'ModuleConfigurationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModuleConfiguration', ], ], 'ModuleParameters' => [ 'type' => 'structure', 'members' => [ 'noBid' => [ 'shape' => 'NoBidModuleParameters', ], 'openRtbAttribute' => [ 'shape' => 'OpenRtbAttributeModuleParameters', ], ], 'union' => true, ], 'NoBidAction' => [ 'type' => 'structure', 'members' => [ 'noBidReasonCode' => [ 'shape' => 'NoBidActionNoBidReasonCodeInteger', ], ], ], 'NoBidActionNoBidReasonCodeInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'NoBidModuleParameters' => [ 'type' => 'structure', 'members' => [ 'reason' => [ 'shape' => 'NoBidModuleParametersReasonString', ], 'reasonCode' => [ 'shape' => 'NoBidModuleParametersReasonCodeInteger', ], 'passThroughPercentage' => [ 'shape' => 'NoBidModuleParametersPassThroughPercentageFloat', ], ], ], 'NoBidModuleParametersPassThroughPercentageFloat' => [ 'type' => 'float', 'box' => true, 'max' => 100, 'min' => 0, ], 'NoBidModuleParametersReasonCodeInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 0, ], 'NoBidModuleParametersReasonString' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'pattern' => '[a-zA-Z0-9]*', ], 'OpenRtbAttributeModuleParameters' => [ 'type' => 'structure', 'required' => [ 'filterType', 'filterConfiguration', 'action', 'holdbackPercentage', ], 'members' => [ 'filterType' => [ 'shape' => 'FilterType', ], 'filterConfiguration' => [ 'shape' => 'FilterConfiguration', ], 'action' => [ 'shape' => 'Action', ], 'holdbackPercentage' => [ 'shape' => 'OpenRtbAttributeModuleParametersHoldbackPercentageFloat', ], ], ], 'OpenRtbAttributeModuleParametersHoldbackPercentageFloat' => [ 'type' => 'float', 'box' => true, 'max' => 100, 'min' => 0, ], 'Protocol' => [ 'type' => 'string', 'enum' => [ 'HTTP', 'HTTPS', ], ], 'RejectLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], ], ], 'RejectLinkResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'peerGatewayId', 'status', 'createdAt', 'updatedAt', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'peerGatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'LinkStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'direction' => [ 'shape' => 'LinkDirection', ], 'flowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'pendingFlowModules' => [ 'shape' => 'ModuleConfigurationList', ], 'attributes' => [ 'shape' => 'LinkAttributes', ], 'linkId' => [ 'shape' => 'LinkId', ], ], ], 'RequesterGatewayStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING_CREATION', 'ACTIVE', 'PENDING_DELETION', 'DELETED', 'ERROR', 'PENDING_UPDATE', 'ISOLATED', 'PENDING_ISOLATION', 'PENDING_RESTORATION', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResponderErrorMasking' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResponderErrorMaskingForHttpCode', ], 'max' => 200, 'min' => 1, ], 'ResponderErrorMaskingAction' => [ 'type' => 'string', 'enum' => [ 'NO_BID', 'PASSTHROUGH', ], ], 'ResponderErrorMaskingForHttpCode' => [ 'type' => 'structure', 'required' => [ 'httpCode', 'action', 'loggingTypes', ], 'members' => [ 'httpCode' => [ 'shape' => 'ResponderErrorMaskingForHttpCodeHttpCodeString', ], 'action' => [ 'shape' => 'ResponderErrorMaskingAction', ], 'loggingTypes' => [ 'shape' => 'ResponderErrorMaskingLoggingTypes', ], 'responseLoggingPercentage' => [ 'shape' => 'ResponderErrorMaskingForHttpCodeResponseLoggingPercentageFloat', ], ], ], 'ResponderErrorMaskingForHttpCodeHttpCodeString' => [ 'type' => 'string', 'max' => 7, 'min' => 3, 'pattern' => 'DEFAULT|4XX|5XX|\\d{3}', ], 'ResponderErrorMaskingForHttpCodeResponseLoggingPercentageFloat' => [ 'type' => 'float', 'box' => true, 'max' => 100, 'min' => 0, ], 'ResponderErrorMaskingLoggingType' => [ 'type' => 'string', 'enum' => [ 'NONE', 'METRIC', 'RESPONSE', ], ], 'ResponderErrorMaskingLoggingTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResponderErrorMaskingLoggingType', ], 'max' => 2, 'min' => 1, ], 'ResponderGatewayStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING_CREATION', 'ACTIVE', 'PENDING_DELETION', 'DELETED', 'ERROR', 'PENDING_UPDATE', 'ISOLATED', 'PENDING_ISOLATION', 'PENDING_RESTORATION', ], ], 'RtbTaggableResourceArn' => [ 'type' => 'string', 'max' => 1600, 'min' => 1, 'pattern' => 'arn:aws:rtbfabric:[a-zA-Z0-9_-]+:[0-9]{12}:gateway/[a-zA-Z0-9-]+(/link/[a-zA-Z0-9-]+)?', ], 'SecurityGroupId' => [ 'type' => 'string', 'pattern' => 'sg-[0-9a-f]{8,40}', ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'String' => [ 'type' => 'string', ], 'SubnetId' => [ 'type' => 'string', 'pattern' => 'subnet-\\w{8,17}', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(resourceArn|internalId|(?!aws:)[a-zA-Z0-9+\\-=._:/@]+)', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'RtbTaggableResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 1600, 'min' => 0, ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TrustStoreConfiguration' => [ 'type' => 'structure', 'required' => [ 'certificateAuthorityCertificates', ], 'members' => [ 'certificateAuthorityCertificates' => [ 'shape' => 'CertificateAuthorityCertificates', ], ], ], 'URI' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '(https|http)://(?:[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?)(?:\\.(?:[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?))+', ], 'URL' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '(https|http)://.+', ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'RtbTaggableResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateLinkModuleFlowRequest' => [ 'type' => 'structure', 'required' => [ 'clientToken', 'gatewayId', 'linkId', 'modules', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], 'modules' => [ 'shape' => 'ModuleConfigurationList', ], ], ], 'UpdateLinkModuleFlowResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'UpdateLinkRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'linkId', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'linkId' => [ 'shape' => 'LinkId', 'location' => 'uri', 'locationName' => 'linkId', ], 'logSettings' => [ 'shape' => 'LinkLogSettings', ], ], ], 'UpdateLinkResponse' => [ 'type' => 'structure', 'required' => [ 'linkId', 'status', ], 'members' => [ 'linkId' => [ 'shape' => 'LinkId', ], 'status' => [ 'shape' => 'LinkStatus', ], ], ], 'UpdateRequesterGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'clientToken', 'gatewayId', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'description' => [ 'shape' => 'UpdateRequesterGatewayRequestDescriptionString', ], ], ], 'UpdateRequesterGatewayRequestDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'UpdateRequesterGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'RequesterGatewayStatus', ], ], ], 'UpdateResponderGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'port', 'protocol', 'clientToken', 'gatewayId', ], 'members' => [ 'domainName' => [ 'shape' => 'DomainName', ], 'port' => [ 'shape' => 'UpdateResponderGatewayRequestPortInteger', ], 'protocol' => [ 'shape' => 'Protocol', ], 'trustStoreConfiguration' => [ 'shape' => 'TrustStoreConfiguration', ], 'managedEndpointConfiguration' => [ 'shape' => 'ManagedEndpointConfiguration', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'gatewayId' => [ 'shape' => 'GatewayId', 'location' => 'uri', 'locationName' => 'gatewayId', ], 'description' => [ 'shape' => 'UpdateResponderGatewayRequestDescriptionString', ], ], ], 'UpdateResponderGatewayRequestDescriptionString' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9 ]+', ], 'UpdateResponderGatewayRequestPortInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 65535, 'min' => 1, ], 'UpdateResponderGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'ResponderGatewayStatus', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Version' => [ 'type' => 'string', 'pattern' => '[a-z0-9-]{1,25}', ], 'VpcId' => [ 'type' => 'string', 'pattern' => 'vpc-[a-f0-9]{8,17}', ], ],];
